/*
Copyright (C) 2024 Signal Messenger, LLC.
SPDX-License-Identifier: AGPL-3.0-only
*/

#ifndef SIGNAL_FTS5_TOKENIZER_H_
#define SIGNAL_FTS5_TOKENIZER_H_

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

typedef struct Fts5Tokenizer Fts5Tokenizer;

#if defined(SIGNAL_FTS5_TOKENIZER_EXTENSION_H_)
typedef struct sqlite3 sqlite3;
#endif

typedef int (*sqlite3__fts5_token_fn)(void *p_ctx,
                                      int t_flags,
                                      const char *p_token,
                                      int n_token,
                                      int i_start,
                                      int i_end);

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

int signal_fts5_tokenize(Fts5Tokenizer *_tokenizer,
                         void *p_ctx,
                         int _flags,
                         const char *p_text,
                         int n_text,
                         sqlite3__fts5_token_fn x_token);

#if defined(SIGNAL_FTS5_TOKENIZER_EXTENSION_H_)
int signal_fts5_tokenizer_init(sqlite3 *db, unsigned char **_pz_err_msg, const void *p_api);
#endif

#if defined(SIGNAL_FTS5_TOKENIZER_EXTENSION_H_)
int fts5_create_signal_tokenizer(void *_p_context,
                                 const unsigned char *const *_az_arg,
                                 int _n_arg,
                                 Fts5Tokenizer **fts5_tokenizer);
#endif

#if defined(SIGNAL_FTS5_TOKENIZER_EXTENSION_H_)
void fts5_delete_signal_tokenizer(Fts5Tokenizer *fts5_tokenizer);
#endif

#if defined(SIGNAL_FTS5_TOKENIZER_EXTENSION_H_)
void fts5_destroy_icu_module(void *_module);
#endif

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif  /* SIGNAL_FTS5_TOKENIZER_H_ */
